////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL SaveScheduleToDataBase(void)
{
    int LocalLoop     = 0;
    char *ColumbName  = NULL;

    _NDBSTable NDBS;

	InitializeTable(&NDBS, 25, MaxSchedules + 1, "Schedule", 8);

    ColumbName = "NonSchedInfo";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));

    ColumbName = "Name";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));
    ColumbName = "Filename";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));
    ColumbName = "Description";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));

    ColumbName = "SQLServer";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));
    ColumbName = "Database";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));
    ColumbName = "DBDriver";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));
    ColumbName = "Username";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));
    ColumbName = "Password";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));
    ColumbName = "IsTrusted";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));
    ColumbName = "WeekDays";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));

    ColumbName = "IncrementHour";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));
    ColumbName = "IncrementMinute";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));

    ColumbName = "BackupWindowTimeBegin";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));
    ColumbName = "BackupWindowTimeEnd";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));
    ColumbName = "StartOnceTime";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));

    ColumbName = "LastRunTime";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));
    ColumbName = "LastRunDate";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));

    ColumbName = "ScheduleID";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));
    ColumbName = "Active";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));
    ColumbName = "OnlyRunOnce";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));

    ColumbName = "Reserved";
    AddColumb(&NDBS, ColumbName, strlen(ColumbName));

    AddEntryByColumbName(&NDBS, "NonSchedInfo", (char *) &NumberOfSetSchedules, sizeof(int));
    AddEntryByColumbName(&NDBS, "NonSchedInfo", (char *) &CurrentScheduleID, sizeof(DWORD));

    while(LocalLoop < MaxSchedules)
    {
        if(Sched[LocalLoop].ScheduleSet == TRUE)
        {
            AddEntryByColumbName(&NDBS, "Name", Sched[LocalLoop].Name, strlen(Sched[LocalLoop].Name));
            AddEntryByColumbName(&NDBS, "Filename", Sched[LocalLoop].Filename, strlen(Sched[LocalLoop].Filename));
            AddEntryByColumbName(&NDBS, "Description", Sched[LocalLoop].Description, strlen(Sched[LocalLoop].Description));

            AddEntryByColumbName(&NDBS, "SQLServer", Sched[LocalLoop].SQLServer, strlen(Sched[LocalLoop].SQLServer));
            AddEntryByColumbName(&NDBS, "Database", Sched[LocalLoop].Database, strlen(Sched[LocalLoop].Database));
            AddEntryByColumbName(&NDBS, "DBDriver", Sched[LocalLoop].DBDriver, strlen(Sched[LocalLoop].DBDriver));
            AddEntryByColumbName(&NDBS, "Username", Sched[LocalLoop].Username, strlen(Sched[LocalLoop].Username));
            AddEntryByColumbName(&NDBS, "Password", Sched[LocalLoop].Password, strlen(Sched[LocalLoop].Password));
            AddEntryByColumbName(&NDBS, "IsTrusted", (char *) &Sched[LocalLoop].IsTrusted, sizeof(BOOL));

            AddEntryByColumbName(&NDBS, "WeekDays", (char *) &Sched[LocalLoop].WeekDays, sizeof(Sched[LocalLoop].WeekDays));

            AddEntryByColumbName(&NDBS, "ScheduleID", (char *) &Sched[LocalLoop].ScheduleID, sizeof(DWORD));

            AddEntryByColumbName(&NDBS, "BackupWindowTimeBegin", (char *) &Sched[LocalLoop].BackupWindowTimeBegin, sizeof(DWORD));
            AddEntryByColumbName(&NDBS, "BackupWindowTimeEnd", (char *) &Sched[LocalLoop].BackupWindowTimeEnd, sizeof(DWORD));
            AddEntryByColumbName(&NDBS, "StartOnceTime", (char *) &Sched[LocalLoop].StartOnceTime, sizeof(DWORD));

            AddEntryByColumbName(&NDBS, "LastRunTime", (char *) &Sched[LocalLoop].LastRunTime, sizeof(DWORD));
            AddEntryByColumbName(&NDBS, "LastRunDate", (char *) &Sched[LocalLoop].LastRunDate, sizeof(DWORD));

            AddEntryByColumbName(&NDBS, "IncrementHour", (char *) &Sched[LocalLoop].IncrementHour, sizeof(WORD));
            AddEntryByColumbName(&NDBS, "IncrementMinute", (char *) &Sched[LocalLoop].IncrementMinute, sizeof(WORD));

            AddEntryByColumbName(&NDBS, "Active", (char *) &Sched[LocalLoop].Active, sizeof(BOOL));
            AddEntryByColumbName(&NDBS, "OnlyRunOnce", (char *) &Sched[LocalLoop].OnlyRunOnce, sizeof(BOOL));
        }

        LocalLoop++;
    }

    if(WriteNDBSFile(&NDBS, ScheduleDB) == FALSE)
        return FALSE;

    FreeTable(&NDBS);

	return TRUE;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL ReadDataBaseToSchedule(void)
{
    _NDBSTable NDBS;
    int LocalLoop = 0;

    if(ReadNDBSFile(&NDBS, ScheduleDB) == FALSE)
        return FALSE;

    RetreiveDataByColumbName(&NDBS, "NonSchedInfo", 0, (char *) &NumberOfSetSchedules);
    RetreiveDataByColumbName(&NDBS, "NonSchedInfo", 1, (char *) &CurrentScheduleID);

    while(LocalLoop < NumberOfSetSchedules)
    {
        Sched[LocalLoop].Name        = (char *) calloc(1024, 1);
        Sched[LocalLoop].Description = (char *) calloc(256, 1);
        Sched[LocalLoop].Filename    = (char *) calloc(256, 1);

        Sched[LocalLoop].SQLServer = (char *) calloc(256, 1);
        Sched[LocalLoop].Database  = (char *) calloc(256, 1);
        Sched[LocalLoop].DBDriver  = (char *) calloc(256, 1);
        Sched[LocalLoop].Username  = (char *) calloc(256, 1);
        Sched[LocalLoop].Password  = (char *) calloc(256, 1);

        RetreiveDataByColumbName(&NDBS, "Name", LocalLoop, Sched[LocalLoop].Name);
        RetreiveDataByColumbName(&NDBS, "Description", LocalLoop, Sched[LocalLoop].Description);
        RetreiveDataByColumbName(&NDBS, "Filename", LocalLoop, Sched[LocalLoop].Filename);

        RetreiveDataByColumbName(&NDBS, "SQLServer", LocalLoop, Sched[LocalLoop].SQLServer);
        RetreiveDataByColumbName(&NDBS, "Database", LocalLoop, Sched[LocalLoop].Database);
        RetreiveDataByColumbName(&NDBS, "DBDriver", LocalLoop, Sched[LocalLoop].DBDriver);
        RetreiveDataByColumbName(&NDBS, "Username", LocalLoop, Sched[LocalLoop].Username);
        RetreiveDataByColumbName(&NDBS, "Password", LocalLoop, Sched[LocalLoop].Password);
        RetreiveDataByColumbName(&NDBS, "IsTrusted", LocalLoop, (char *) &Sched[LocalLoop].IsTrusted);

        RetreiveDataByColumbName(&NDBS, "WeekDays", LocalLoop, (char *) &Sched[LocalLoop].WeekDays);

        RetreiveDataByColumbName(&NDBS, "ScheduleID", LocalLoop, (char *) &Sched[LocalLoop].ScheduleID);

        RetreiveDataByColumbName(&NDBS, "BackupWindowTimeBegin", LocalLoop, (char *) &Sched[LocalLoop].BackupWindowTimeBegin);
        RetreiveDataByColumbName(&NDBS, "BackupWindowTimeEnd", LocalLoop, (char *) &Sched[LocalLoop].BackupWindowTimeEnd);
        RetreiveDataByColumbName(&NDBS, "StartOnceTime", LocalLoop, (char *) &Sched[LocalLoop].StartOnceTime);

        RetreiveDataByColumbName(&NDBS, "IncrementHour", LocalLoop, (char *) &Sched[LocalLoop].IncrementHour);
        RetreiveDataByColumbName(&NDBS, "IncrementMinute", LocalLoop, (char *) &Sched[LocalLoop].IncrementMinute);

        RetreiveDataByColumbName(&NDBS, "LastRunTime", LocalLoop, (char *) &Sched[LocalLoop].LastRunTime);
        RetreiveDataByColumbName(&NDBS, "LastRunDate", LocalLoop, (char *) &Sched[LocalLoop].LastRunDate);

        RetreiveDataByColumbName(&NDBS, "Active", LocalLoop, (char *) &Sched[LocalLoop].Active);
        RetreiveDataByColumbName(&NDBS, "OnlyRunOnce", LocalLoop, (char *) &Sched[LocalLoop].OnlyRunOnce);

        Sched[LocalLoop].ScheduleSet = TRUE;

        LocalLoop++;
    }

    FreeTable(&NDBS);

	return TRUE;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

